package editor;

import java.awt.Color;
import java.util.ArrayList;

import editor.RoomEditorPanel.SpawnPointAndDepth;

public class RogueBlockLoadData {
	
	
	private int width;
	private int height;
	private String image;
	private Color transparent;
	private Boolean isPassThru;
	private ArrayList<SpawnPointAndDepth> spawnPoints;
	
	public RogueBlockLoadData() {
		spawnPoints = new ArrayList<SpawnPointAndDepth>();
	}
	
	
	
	public int getWidth() {
		return width;
	}
	public void setWidth(int width) {
		this.width = width;
	}
	public int getHeight() {
		return height;
	}
	public void setHeight(int height) {
		this.height = height;
	}
	public String getImage() {
		return image;
	}
	public void setImage(String image) {
		this.image = image;
	}
	public Color getTransparent() {
		return transparent;
	}
	public void setTransparent(Color transparent) {
		this.transparent = transparent;
	}
	public Boolean isPassThru() {
		return isPassThru;
	}
	public void setPassThru(Boolean isPassThru) {
		this.isPassThru = isPassThru;
	}
	
	public void addSpawnPoint(SpawnPointAndDepth p) {
		int spawnPointsSize = spawnPoints.size();
		
		for(int i = 0; i < spawnPoints.size(); i++) {
			if(spawnPoints.get(i).depth > p.depth) {
				spawnPoints.add(i, p);
				i = spawnPoints.size();
			}
		}
		
		if(spawnPointsSize == spawnPoints.size()) {
			spawnPoints.add(p);
		}
	}



	public ArrayList<SpawnPointAndDepth> getSpawnPoints() {
		return spawnPoints;
	}
	
	
	
	
}
